#include "SetAutoAdjustModeCommand.h"

namespace SimulationEngine
{

SetAutoAdjustModeCommand::SetAutoAdjustModeCommand():ICommand(ConfigurationServer::GetInstance()->GetCommandSetAutoAdjustModeKey())
{
}

SetAutoAdjustModeCommand::~SetAutoAdjustModeCommand()
{
}

list<DataParameter*> SetAutoAdjustModeCommand::execute(list <DataParameter *> pars)
{	
	list <DataParameter *> ret;
	DataBool *databool = (DataBool *)(pars.front());
	
	if (databool->GetValue() && SimulationEngineController::GetInstance()->GetSyncMode())
	{
		ret.push_back(new DataString("Error: Cannot set Auto-Adjust mode true when running on synchronic mode"));
	}
	else
	{		
		SimulationEngineController::GetInstance()->SetAutoAdjustMode(databool->GetValue());		
		ret.push_back(new DataString("Auto-Adjust mode has been successfully setted"));
	}
	
	return ret;
}

}
